<?php
# Which page is this header being loaded on?
$page = !empty($page)? $page: "home";

#Show the home link if you are not on the home page
$homeLink = $page != "home"? "<a href=\"".base_url()."\">Home</a> ": "";
#Show the other links as active if on that page
$aboutLink = $page != "about_us"? "<a href=\"".base_url()."/Page/about_us\">About TMIS</a>": "<span class='label'>About TMIS</span>";
$faqsLink = " ".($page != "faqs"? "<a href=\"".base_url()."/Page/faqs\">FAQs</a>": "<span class='label'>FAQs</span>");
$verifyLink = " ".($page != "verify"? "<a href=\"".base_url()."/Page/verify\">Verify</a>": "<span class='label'>Verify</span>");
$logoutLink = ($page != "login" && isset($_SESSION['__user_id'])? " <a href=\"".base_url()."/Account/logout\">Logout</a>": "");

?>

<nav class="navbar fixed-top navbar-expand-lg navbar-light bg-white border-bottom">
    <div class="container-fluid d-flex justify-content-between">
        <a class="navbar-brand" href="<?php echo base_url();?>">
            <img src="<?php echo base_url();?>/assets/images/tmis-logo.svg" alt="TMIS logo" width="auto" height="50">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse w-auto pt-3 pt-md-0" id="navbarSupportedContent">
            <ul class="navbar-nav ms-auto me-0 mb-2 mb-lg-0 d-flex align-items-center">
                <li class="nav-item ms-3">
                    <?php echo $homeLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $aboutLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $faqsLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $verifyLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $logoutLink; ?>
                </li>
            </ul>
        </div>
    </div>
</nav>