<?php $msg = empty($msg)? get_session_msg($this): $msg; ?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo SITE_TITLE;?>: Details</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <?php echo minify_js('vacancy-details', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js'));?>
    <script type="text/javascript">
    var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()" onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <table width="100%" border="0" cellspacing="0" cellpadding="5">
        <?php
$this->session = \Config\Services::session();
echo !empty($msg)?"<tr><td>".format_notice($msg)."</td></tr>":"";
    
# Show the vancancy details
if (!empty($details)) {
    echo "<tr><td class='h2' style='padding-top:0px;'><b>".$details['topic']."</b></td></tr>
	<tr><td class='h3 value'><div class='nextdiv'>ROLE: ".$details['role_name']."</div><div class='lastdiv'>AT: ".$details['institution_name']."</div></td></tr>
	<tr><td>".str_replace("href=", " target='_blank' href=", html_entity_decode($details['details'], ENT_QUOTES))."</td></tr>
	<tr><td style='padding-top:20px;'><div class='leftnote h3 value'>Respond By: ".date('d-M-Y', strtotime($details['end_date']))."</div></td></tr>";
    
    # Show the apply button
    if (check_access($this, 'apply_for_job', 'boolean') || !$this->session->get('__user_id')) {
        echo "<tr><td style='padding-top:20px;text-align:center;'><div id='apply_btn_div'><input type='button' id='applyforjob' name='applyforjob' style='width:200px;' value='APPLY' ";
    
        if ($this->session->get('__user_id')) {
            echo " class='btn frompop' data-rel='".base_url()."/Job/apply/action/confirm/id/".$details['id']."' ";
        } else {
            echo " class='btn' onclick=\"updateFieldLayer('".base_url()."/Job/apply/id/".$details['id']."','','apply_btn_div','application_option_div','')\" ";
        }
    
        echo " /></div><div id='application_option_div' style='display:none;'></div></td></tr>";
    }
}
?>
    </table>
    <input type="hidden" id="layerid" name="layerid" value="" />
</body>

</html>