<?php
$this->session = \Config\Services::session();
$forwardUrl = !empty($forward)? $forward: get_user_dashboard($this, $this->session->get('__user_id'));
?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>:
        <?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Edit'): 'New';?> User</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <?php echo minify_js('user-new_user', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js'));?>
    <script type="text/javascript">
    var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    <?php echo !empty($id) && !empty($result['boolean']) && $result['boolean']?"window.top.location.href = '".$forwardUrl."';": "";?>
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()" onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content p-3 pt-5 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3><?php echo !empty($id)? (!empty($action) && $action=='view'? 'View ':'Edit '): 'New ';?>User</h3>
                <?php echo !empty($msg)?"<tr><td>".format_notice($this, $msg)."</td></tr>": "";?>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <form id="user_data" method="post" autocomplete="off" action="<?php echo base_url().'/User/add'.(!empty($id)? '/id/'.$id: '');?>" class='simplevalidator'>
                    <table border="0" cellspacing="0" cellpadding="10">
                        <tbody>
                            <tr class="row mb-3">
                                <td class="label text-start col-md-4">Role:</td>
                                <td class="col-md-7">
                                <?php
                                
                                if (!empty($id) && $this->session->get('role__roles') || (!empty($action) && $action=='view')) {
                                    echo "<div class='value'>".$this->session->get('role__roles')."</div>";
                                } else {?><input type="text" id="role__roles" name="role__roles" title="Select Role" placeholder="Select User Role" class="textfield selectfield" value="<?php echo $this->session->get('role__roles');?>" style="width:97%;" /><?php }?>
                                
                                </td>
                            </tr>
                            <tr class="row mb-3">
                                <td class="label text-start col-md-4">Surname:</td>
                                <td class="col-md-7"><?php if (!empty($action) && $action=='view') { echo "<div class='value'>".$this->session->get('lastname')."</div>"; } else {?><input type="text" id="lastname" name="lastname" title="Surname" class="textfield" style="width:97%;" value="<?php echo $this->session->get('lastname');?>" /><?php }?></td>
                            </tr>
                            <tr class="row mb-3">
                                <td class="label text-start col-md-4">Other Names:</td>
                                <td class="col-md-7"><?php if (!empty($action) && $action=='view') { echo "<div class='value'>".$this->session->get('firstname')."</div>"; } else {?><input type="text" id="firstname" name="firstname" title="Other Names" class="textfield" style="width:97%;" value="<?php echo $this->session->get('firstname');?>" /><?php }?></td>
                            </tr>
                            <tr class="row mb-3">
                                <td class="label text-start col-md-4">Email Address:</td>
                                <td class="col-md-7">
                                    <?php #if(!empty($id) && $this->session->get('emailaddress') || (!empty($action) && $action=='view')){
                                    if (!empty($action) && $action=='view') {
                                        echo "<div class='value'>".$this->session->get('emailaddress')."</div>";
                                    } else {?><input type="text" id="emailaddress" name="emailaddress" title="Email Address" class="textfield" style="width:97%;" value="<?php echo $this->session->get('emailaddress');?>" /><span class="smalltext d-block mt-2">The user's password will be automatically generated and sent to this email address.</span><?php }?>
                                </td>
                            </tr>
                            <tr class="row mb-3">
                                <td class="label text-start col-md-4">Telephone:</td>
                                <td class="col-md-7">
                                    <?php if (!empty($action) && $action=='view') {
                                    echo "<div class='value'>".$this->session->get('telephone')."</div>";
                                    } else {?><input type="text" id="telephone" name="telephone" title="Telephone" placeholder="Optional (e.g: 0782123456)" maxlength="10" class="textfield numbersonly telephone optional" style="width:97%;" value="<?php echo $this->session->get('telephone');?>" /><?php }?>
                                </td>
                            </tr>
                            <?php if (!(!empty($action) && $action=='view')) {?>
                            <tr class="row mb-3">
                                <td>&nbsp;</td>
                                <td>
                                    <input type="submit" name="save" id="save" class="btn" value="SAVE" />
                                    
                                    <?php
                                    
                                    if (!empty($actionurl) && $actionurl == 'update') {
                                        $forward = "user/update_status";
                                    } elseif (!empty($actionurl) && $actionurl == 'changepassword') {
                                        $forward = "user/change_password";
                                    } elseif (!empty($actionurl) && $actionurl == 'setpermission') {
                                        $forward = "user/set_permissions";
                                    }

                                    echo !empty($id)? "<input type='hidden' id='userid' name='userid' value='".$id."' /><input type='hidden' id='forward' name='forward' value='".$forward."' />": "";
                                    
                                    ?>
                                </td>
                            </tr>
                        </tbody>
                        <?php }?>
                    </table>
                </form>
            </section>
        </main>
    </div>
        <?php echo view("addons/secure_footer");?>
</body>

</html>
