<?php
$this->session = \Config\Services::session();
$forwardUrl = !empty($forward)? $forward: get_user_dashboard($this, $this->session->get('__user_id'));
?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: Retirement Application</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <?php echo minify_js('retirement-apply', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.callout.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js'));?>

    <script type="text/javascript">
    var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    <?php echo !empty($id) && !empty($result['boolean']) && $result['boolean']?"window.top.location.href = '".$forwardUrl."';": "";?>
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()" onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content px-3 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3>Retirement Application</h3>
                <?php echo !empty($msg)?"<tr><td>".format_notice($this, $msg)."</td></tr>": "";?>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <form id="retirement_application" method="post" autocomplete="off" action="<?php echo base_url().'/Retirement/apply';?>" class='w-100 simplevalidator'>
                    <table class="d-block w-100">
                        <?php

                        if (empty($id) && !empty($current_application)) {
                            echo "<tr><td>".format_notice($this, "WARNING: You have already applied for retirement. Please await action by the approving authorities. <br><br>If you want to cancel your current application, go to <a href='".base_url()."/Retirement/cancel'>the cancellation page</a>.")."</td></tr>";
                        } else {

                        ?>
                        <tr class="d-flex justify-content-start align-items-center mb-3 pb-3 border-bottom">
                            <td class="label d-block mb-2 me-2">Proposed Retirement Date:</td>
                            <td class="d-block">

                            <?php

                            if (!empty($id)) {
                                echo "<div class='value'>".$this->session->get('retirementdate')."</div>";
                            } else {

                            ?>

                                <input type="text" id="retirementdate" name="retirementdate" title="Retirement Date" class="textfield datefield" value="<?php echo $this->session->get('retirementdate');?>" />

                            <?php } ?>

                            </td>
                        </tr>
                        <tr class="d-block mb-3">
                            <td class="label top d-block p-0 mt-0 mb-2 me-2 text-start">Reason:</td>
                            <td class="d-block w-100">

                            <?php

                            if (!empty($id)) {
                                echo "<div class='value'>".$this->session->get('retirementreason')."</div>";
                            } else {

                            ?>

                            <textarea id="retirementreason" name="retirementreason" title="Retirement Reason" placeholder="Enter the reason for your retirement application (Optional)" class="d-block w-100 textfield optional" style="min-height: 200px;">
                            <?php echo $this->session->get('retirementreason');?>
                            </textarea>

                            <?php } ?>

                            </td>
                        </tr>

                        <?php } if (empty($id) && empty($current_application)) {?>
                        
                        <tr>
                            <!-- <td>&nbsp;</td> -->
                            <td><input type="submit" name="submit" id="submit" class="btn" value="SUBMIT" /></td>
                        </tr>

                        <?php } ?>
                    </table>
                </form>
            </section>
        </main>
    </div>

    <?php echo view("addons/secure_footer");?>

</body>

</html>