<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: About Us</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <?php echo minify_js('page-about_us', array('jquery-2.1.1.min.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.responsive.js'));?>
</head>

<body>
    <?php echo view("addons/public_header", array("page"=>"about_us"));?>

    <div class="container-fluid mx-auto p-3 pt-5 p-md-5 m-0 app-area-page">
        <div class="about-area bg-white p-3 p-md-5 mt-5 border">
            <span class="d-block h2 mb-4">About TMIS</span>
            <div class="picturediv d-md-flex align-items-stretch">
                <div class="img">
                    <img src="<?php echo base_url();?>/assets/images/minister_of_education.jpg" alt="Minister of Education, Science, Technology and Sports">
                </div>
                <div class="content p-3 p-md-5 d-flex flex-column justify-content-end">
                    <span class="name">Mrs. Janet Kataaha Museveni</span>
                    <span class="caption">Minister of Education and Sports</span>
                </div>
            </div>
            <div class="txt">
                <p>The Teacher Management Information System (TMIS) is a system aimed at streamlining the delivery of government services to members of the teaching profession in Uganda. The TMIS is a simple user-friendly approach to supporting a harmonized and timely access to teacher information at all administrative levels of the Ministry of Education and Sports and associated agencies at national, district and education institution levels.</p>
                <p>Its main objective is to solve the problem of disjointed teacher records across the various sections of government and the education ministry. Development of this system was commissioned in 2014 by the Education Ministry - headed by the Minister of Education and Sports, Mrs. Janet Kataaha Museveni and was supported by United Nations Educational, Scientific and Cultural Organization (UNESCO). The Ugandan Ministry of Education and Sports (MoES) has outlined in various Government policy documents goals that include increasing access and retention, reducing inequalities, improving relevance and quality of education in Uganda.</p>
                <p>According to the Teacher Issues in Sub-Sahara Africa (TISSA) report, Uganda faces challenges in the quantity and quality of teachers at all levels. The study also revealed that Uganda lacks reliable data on teachers with most of the administrative data being manually generated. To address these concerns, UNESCO in collaboration with the MoES is implementing the CapEFA programme for teachers and TMIS is one of the key components of this initiative. The implementation of TMIS module is also an aspect of strengthening the Education Management Information System (EMIS) and broadening teacher data needs across several sections of the ministry.</p>
                <p>TMIS provides accurate information regarding demand for teachers at primary and secondary level. Therefore, the Ministry will be able to make accurate predictions and plans for training and recruitment of needed teaching resources. This will ensure that pre-service and in-service training needs are evidence-based by removing the guesswork and reliance on outdated census data. In addition, TMIS will help to speed up document processing and improve the performance of education officers in doing their job by enabling faster issuance of certificates and case follow up. The Teacher Instructor Education and Training (TIET) Department of the ministry will use information from the teachers to perform in-service training and planning hence improving the quality of teachers in Ugandan schools by ensuring that there are sufficient opportunities for upgrading pedagogical skills.</p>
                <h4>Act 13 of the (Pre-primary, Primary and post-primary) Act 2008 clearly states that ‘No person shall teach in any public or private school of any description unless he or she is registered as a teacher or licensed to teach under this Act.’</h4>
                <p>However, as old systems are being phased out, all teachers will be required to register with the TMIS system to receive service as well as follow up on their current and future service requests from the ministry. If the reader is a qualified teacher, they are encouraged to start their registration process now by clicking on the REGISTER button below.</p>
                <button type="button" name="backtostep1" id="backtostep1" class="btn btn-primary">REGISTER</button>
            </div>
        </div>
    </div>

    <?php echo view("addons/public_footer");?>

</body>

</html>