<?php
$this->session = \Config\Services::session();
$forwardUrl = !empty($forward)? $forward: get_user_dashboard($this, $this->session->get('__user_id'));
?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>:
        <?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Edit'): 'New';?> Census</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <?php echo minify_js('census-new_census', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.callout.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js'));?>

    <script type="text/javascript">
    var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    <?php echo !empty($id) && !empty($result['boolean']) && $result['boolean']?"window.top.location.href = '".$forwardUrl."';": "";?>
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()" onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content p-3 pt-5 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3><?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Edit'): 'New';?>Census</h3>

            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <form id="census_data" method="post" autocomplete="off" action="<?php echo base_url().'/Census/add'.(!empty($id)? '/id/'.$id: '');?>" class='simplevalidator'>
                    <table class="d-block w-100" border="0" cellspacing="0" cellpadding="10">
                        <tr class="d-flex flex-wrap justify-content-start align-items-center border-bottom pb-3 mb-3">
                            <td class="label text-start me-3">Teacher:</td>
                            <td style="">
                            <?php
 
                            if (!empty($id)) {
                                echo "<div class='value'>".$this->session->get('teachername__teachers')."</div>";
                            } else {

                            ?>
                            <input type="text" id="teachername__teachers" name="teachername__teachers" title="Select or Search for Teacher" placeholder="Select or Search for Teacher" class="textfield selectfield searchable" value="<?php echo $this->session->get('teachername__teachers');?>" style="width:95%;" /><input type='text' class="textfield" id='teacherid' name='teacherid' value='<?php echo $this->session->get('teacherid');?>' style="display:none;" /><?php }?></td>
                        </tr>
                        <tr class="d-flex flex-wrap justify-content-start align-items-center border-bottom pb-3 mb-3">
                            <td class="label top p-0 text-start me-3">Responsibilities:</td>
                            <td>
                            <?php echo "<div style='max-height:200px; overflow-y: auto; overflow-x: hidden;'><table border='0' cellspacing='0' cellpadding='0' class='listtable'>";
                            if (!empty($responsibility_list)) {
                            echo "<tr class='header'><td>Code</td><td>Name</td></tr>";
                            foreach ($responsibility_list as $row) {
                            echo "<tr class='listrow'><td>".$row['code']."</td>

                            <td><input type='checkbox' name='responsibility[]' id='responsibility_".$row['id']."' value='".$row['id']."' ".($this->session->get('responsibility') && in_array($row['id'], $this->session->get('responsibility'))? ' checked': '')."><label for='responsibility_".$row['id']."' style='white-space: nowrap;'>".$row['responsibility']."</label></td>
                            </tr>";
                            }
                            } else {
                            echo "<tr><td class='p-0'>".format_notice($this, 'ERROR: There are no responsibilities to show.')."</td></tr>";
                            }
                            echo "</table></div>";
                            ?>
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                        </tr>
                        <tr class="d-flex flex-wrap justify-content-start border-bottom pb-3 mb-3">
                            <td class="label top p-0 text-start me-3">Training:</td>
                            <td class="border">
                            <?php
                            echo "<div style='max-height:200px; overflow-y: auto; overflow-x: hidden;'>
                            <table border='0' cellspacing='0' cellpadding='0' class='listtable'>";

                            if (!empty($training_list)) {
                            echo "<tr class='header'><td>Code</td><td>Name</td><td>Type</td></tr>";
                            foreach ($training_list as $row) {
                            echo "<tr class='listrow'><td>".$row['code']."</td>

                            <td><input type='checkbox' name='training[]' id='training_".$row['id']."' value='".$row['id']."' ".($this->session->get('training') && in_array($row['id'], $this->session->get('training'))? ' checked': '')."><label for='training_".$row['id']."' style='white-space: nowrap;'>".$row['training']."</label></td>
                            <td>".ucfirst($row['type'])."</td>
                            </tr>";
                            }
                            } else {
                            echo "<tr><td>".format_notice($this, 'ERROR: There are no training items to show.')."</td></tr>";
                            }
                            echo "</table></div>";
                            ?>
                            </td>
                        </tr>
                        <tr class="d-flex flex-wrap justify-content-start align-items-center border-bottom pb-3 mb-3">
                            <td class="label text-start me-3 p-0">Census Period:</td>
                            <td>
                                <div class='nextdiv'>
                                    <input type="text" id="censusstart"
                                        name="censusstart" title="Census Start Date"
                                        class="textfield datefield history"
                                        placeholder="Census Start Date"
                                        value="<?php echo $this->session->get('censusstart')? date('d-M-Y', strtotime($this->session->get('censusstart'))):'';?>" />
                                </div>
                                <div class='nextdiv'>
                                    <input type="text" id="censusend"
                                        name="censusend" title="Census End Date"
                                        placeholder="Census End Date"
                                        class="textfield datefield history"
                                        value="<?php echo $this->session->get('censusend')? date('d-M-Y', strtotime($this->session->get('censusend'))): '';?>" />
                                </div>
                            </td>
                        </tr>
                        <tr class="d-flex flex-wrap justify-content-start align-items-center border-bottom pb-3 mb-3">
                            <td class="label text-start me-3">Average Weekly Workload:</td>
                            <td>
                            <?php if (!empty($action) && $action=='view') {
                            echo "<div class='value'>".$this->session->get('averageworkload')."</div>";
                            } else {?><input type="text" id="averageworkload" name="averageworkload" title="Average Weekly Workload"
                                    placeholder="Time in hours" maxlength="5"
                                    class="textfield numbersonly"
                                    value="<?php echo $this->session->get('averageworkload');?>" /><?php }?>
                            </td>
                        </tr>

                        <?php if (!(!empty($action) && $action=='view')) {?>
                        <tr>
                            <td><input type="submit" name="save" id="save" class="btn"
                                    value="SAVE" /><?php
                            echo !empty($id)? "<input type='hidden' id='schoolid' name='censusid' value='".$id."' />": "";
                            echo "<input type='hidden' id='forward' name='forward' value='census/lists".(!empty($action) && $action!='view'? '/action/'.$action: '')."' />";
                            ?></td>
                        </tr>
                        <?php }?>
                    </table>
                </form>
            </section>
        </main>
    </div>

    <?php echo view("addons/secure_footer");?>

</body>

</html>