<?php
# Which page is this header being loaded on?
$page = !empty($page)? $page: "home";

#Show the home link if you are not on the home page
$homeLink = $page != "home"? "<a href=\"".base_url()."\">Home</a> ": "";
#Show the other links as active if on that page
$aboutLink = $page != "about_us"? "<a href=\"".base_url()."/Page/about_us\">About TMIS</a>": "<span class='label'>About TMIS</span>";
$faqsLink = " ".($page != "faqs"? "<a href=\"".base_url()."/Page/faqs\">FAQs</a>": "<span class='label'>FAQs</span>");
$verifyLink = " ".($page != "verify"? "<a href=\"".base_url()."/Page/verify\">Verify</a>": "<span class='label'>Verify</span>");
$logoutLink = ($page != "login" && isset($_SESSION['__user_id'])? " <a href=\"".base_url()."/Account/logout\">Logout</a>": "");

#Show the other links as active if on that page
$termsLink = $page != "terms"? "<a href=\"".base_url()."/Page/terms_of_use\">Terms</a>": "<span class='label'>Terms</span>";
$privacyLink = " ".($page != "privacy"? "<a href=\"".base_url()."/Page/privacy_policy\">Privacy</a>": "<span class='label'>Privacy</span>");
$contactLink = " ".($page != "contact_us"? "<a href=\"".base_url()."/Page/contact_us\">Contact Us</a>": "<span class='label'>Contact Us</span>");
#$applyLink = " &nbsp;&nbsp;|&nbsp;&nbsp; ".($page != "new_account"? "<a href=\"".base_url()."register/step_one\">New Account</a>": "<span class='label'>New Account</span>");

?>

<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url(); ?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url(); ?>/favicon.ico" type="image/x-icon">
    <?php $this->session = \Config\Services::session(); ?>
    <title><?php echo SITE_TITLE; ?>: Welcome</title>
    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/css/tmis.css" />   
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
    <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
        dataLayer.push(arguments);
    }
    gtag('js', new Date());

    gtag('config', 'G-JM8P0P17Z6');
    </script>
    <script src="https://unpkg.com/swiper@7.0.8/swiper-bundle.min.js" crossorigin="anonymous"></script>
</head>

<body>
    <div class="container-fluid mx-auto p-0 m-0 app-area-login home">
        <div class="app-area-login-img bg-black">
            <div class="swiper mySwiper">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <img src="<?php echo base_url();?>/assets/images/h3.jpg" srcset="<?php echo base_url();?>/assets/images/h3-phone.jpg 480w, <?php echo base_url();?>/assets/images/h3.jpg 1080w" sizes="50vw" alt="Ugandan Crested Crane." />
                    </div>
                    <div class="swiper-slide">
                        <img src="<?php echo base_url();?>/assets/images/h4.jpg" srcset="<?php echo base_url();?>/assets/images/h4-phone.jpg 480w, <?php echo base_url();?>/assets/images/h4.jpg 1080w" sizes="50vw" alt="Ugandan Teacher drawing lines on a blackboard." />
                    </div>
                    <div class="swiper-slide">
                        <img src="<?php echo base_url();?>/assets/images/h1.jpg" srcset="<?php echo base_url();?>/assets/images/h1-phone.jpg 480w, <?php echo base_url();?>/assets/images/h1.jpg 1080w" sizes="50vw" alt="Ugandan student in class." />
                    </div>
                    <div class="swiper-slide">
                        <img src="<?php echo base_url();?>/assets/images/h2.jpg" srcset="<?php echo base_url();?>/assets/images/h2-phone.jpg 480w, <?php echo base_url();?>/assets/images/h2.jpg 1080w" sizes="50vw" alt="Students in class in rural Uganda." />
                    </div>
                </div>
            </div>
        </div>
        <div class="app-area-login-form p-3 p-md-5 pt-5">
            <span class="d-block logo-wrap">
                <img src="<?php echo base_url();?>/assets/images/tmis-logo.svg" width='200px' height='60px' alt="TMIS logo">
            </span>
            <span class="h3 d-block pt-3">Sign In</span>
            <span class="d-block">
                <div id="registration_close_btn">&nbsp;</div>
            </span>
            <p>Teacher Management Information System</p>
            <table width="100%" class="bg-white">
                <tr>
                    <td>
                        <div class="loginhomeform">
                            <form method="post" autocomplete="off" class="my-md-3 p-4 py-3">
                                <table>
                                    <tr>
                                        <td class="trlogin">
                                            <label for="inputEmail4" class="labeltxt ">Username</label>
                                            <input type="text" id="loginusername" name="loginusername"
                                                placeholder="Username" class="textfield form-control-input p-3" value=""
                                                maxlength="100" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="trlogin">
                                            <label for="inputPassword4" class="labeltxt"
                                                style="padding-top: 8px;">Password</label>
                                            <input type="password" id="loginpassword" name="loginpassword"
                                                placeholder="Password" class="textfield form-control-input p-3" value=""
                                                maxlength="100" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <a class="p-login text-black"
                                                href="<?php echo base_url() . '/Account/forgot'; ?>">Forgot Username or
                                                Password?</a>
                                            <button type="button" class="bluebtn" id="submitlogin"
                                                name="submitlogin">LOGIN</button>
                                            <p class="mt-5">
                                                Don't have an account?
                                                <a href="<?php echo base_url() . '/Register/step_one'; ?>"
                                                    class="fw-normal text-primary">Register as a Teacher</a>
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                            </form>
                        </div>
                    </td>
                </tr>
            </table>
            <ul class="d-md-flex mt-3 p-3 bg-white">
                <li class="nav-item">
                    <?php echo $aboutLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $verifyLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $faqsLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $termsLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $contactLink; ?>
                </li>
            </ul>
        </div>
    </div>
    <?php echo minify_js('home', array('jquery-2.1.1.min.js', 'tmis.js', 'tmis.fileform.js'));?>
    <script>
    var swiper = new Swiper(".mySwiper", {
        speed: 5000,
        spaceBetween: 30,
        effect: "fade",
        autoplay: {
            delay: 25000,
            disableOnInteraction: false,
        },
    });
    </script>
</body>

</html>