<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Models\_approval_chain;
use App\Models\_query_reader;

class _vacancy extends Model
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->approval_chain = new _approval_chain();
        $this->query_reader = new _query_reader();
        $this->session = \Config\Services::session();
    }
    
    # Add a new vacancy.
    public function add_new($vacancyDetails)
    {
        $isAdded = false;
        $required = array('institution__institutions', 'role__jobroles', 'headline', 'summary', 'details', 'publishstart', 'publishend');
        
        # 1. Add all provided data into the session
        $passed = process_fields($this, $vacancyDetails, $required, array("/", "<", ">", "\"", "=", "(", ")", "!", "#", "%", "&", "?", ":", ";", "'"));
        $msg = !empty($passed['msg'])? $passed['msg']: "";
        # 2. Save the data into the database
        if ($passed['boolean']) {
            $details = $passed['data'];
            $vacancyId = $this->query_reader->add_data('add_vacancy_data', array('institution'=>$details['institution__institutions'], 'role'=>$details['role__jobroles'], 'topic'=>$details['headline'], 'summary'=>$details['summary'], 'details'=>$details['details'], 'start_date'=>format_date($details['publishstart'], 'YYYY-MM-DD'), 'end_date'=>format_date($details['publishend'], 'YYYY-MM-DD'), 'added_by'=>$this->session->get('__user_id') ));
            
            $isAdded = !empty($vacancyId)? true: false;
            if ($isAdded) {
                # Notify approving parties
                $result = $this->approval_chain->add_chain($vacancyId, 'vacancy', '1', 'approved','New vacancy added');
                $msg = $result['boolean']? "The data has been saved and the approving parties have been notified.": $result['msg'];
                $this->session->remove($details);
            }
        }
        
        return array('boolean'=>$isAdded, 'msg'=>$msg, 'id'=>(!empty($vacancyId)? $vacancyId: ''));
    }
        
    
        
    
    # Update a vacancy
    public function updated($vacancyId, $vacancyDetails)
    {
        $isUpdated = false;
        $required = array('headline', 'summary', 'details', 'publishstart', 'publishend');
        # 1. Add all provided data into the session
        $passed = process_fields($this, $vacancyDetails, $required, array("/", "<", ">", "\"", "=", "(", ")", "!", "#", "%", "&", "?", ":", ";"));
        $msg = !empty($passed['msg'])? $passed['msg']: "";
        # 2. Save the data into the database
        if ($passed['boolean']) {
            $details = $passed['data'];
            $isUpdated = $this->query_reader->run('update_vacancy_data', array('topic'=>$details['headline'], 'summary'=>$details['summary'], 'details'=>$details['details'], 'start_date'=>format_date($details['publishstart'], 'YYYY-MM-DD'), 'end_date'=>format_date($details['publishend'], 'YYYY-MM-DD'), 'vacancy_id'=>$vacancyId, 'updated_by'=>$this->session->get('__user_id') ));
            
            if ($isUpdated) {
                $this->session->remove($details);
            }
        }
        
        return array('boolean'=>$isUpdated, 'msg'=>$msg, 'id'=>$vacancyId);
    }
        
    
    # Change the status of the vacancy
    public function change_status($vacancyId, $newStatus)
    {
        return $this->query_reader->run('update_vacancy_status', array('vacancy_id'=>$vacancyId, 'status'=>$newStatus, 'updated_by'=>$this->session->get('__user_id')));
    }
    
        
        
    
    # Get list of vacancies
    public function get_list($instructions=array())
    {
        $searchString = " V.status='published' ";
        $orderBy = " V.date_added DESC ";
        if (!empty($instructions['action']) && $instructions['action']== 'publish') {
            $searchString = " V.status IN ('saved','verified') ";
        } elseif (!empty($instructions['action']) && $instructions['action']== 'archive') {
            $searchString = " V.status IN ('saved','archived') ";
        } elseif (!empty($instructions['action']) && $instructions['action']== 'verify') {
            $searchString = " V.status='saved' ";
        } elseif (!empty($instructions['action']) && $instructions['action']== 'public') {
            $searchString = " V.status='published' AND (DATE(V.start_date) < NOW() AND DATE(V.end_date) > NOW()) ";
            $orderBy = " V.end_date ASC ";
        }
        
        # If a search phrase is sent in the instructions
        if (!empty($instructions['searchstring'])) {
            $searchString .= " AND ".$instructions['searchstring'];
        }
        
        # Instructions
        $count = !empty($instructions['pagecount'])? $instructions['pagecount']: NUM_OF_ROWS_PER_PAGE;
        $start = !empty($instructions['page'])? ($instructions['page']-1)*$count: 0;
        
        return $this->query_reader->get_list('get_vacancy_list_data', array('search_query'=>$searchString, 'limit_text'=>$start.','.($count+1), 'order_by'=>$orderBy));
    }
    
    
    # Get details of a vacancy
    public function get_details($vacancyId)
    {
        return $this->query_reader->get_row_as_array('get_vacancy_by_id', array('vacancy_id'=>$vacancyId));
    }


    # Populate a vacancy session profile
    public function populate_session($vacancyId)
    {
        $details = $this->query_reader->get_row_as_array('get_vacancy_by_id', array('vacancy_id'=>$vacancyId));
        if (!empty($details)) {
            $this->session->set('institution__institutions', $details['institution_name']);
            $this->session->set('role__jobroles', $details['role_name']);
            $this->session->set('headline', $details['topic']);
            $this->session->set('summary', $details['summary']);
            $this->session->set('details', $details['details']);
            $this->session->set('publishstart', date('d-M-Y', strtotime($details['start_date'])));
            $this->session->set('publishend', date('d-M-Y', strtotime($details['end_date'])));
        }
    }
    


    # Clear a vacancy session profile
    public function clear_session()
    {
        $fields = ['institution__institutions', 'role__jobroles', 'headline', 'summary', 'details', 'publishstart', 'publishend'];
        $this->session->remove($fields);
    }
    
    
    
    
    # Approve or reject a vacancy
    public function verify($instructions)
    {
        $result = array('boolean'=>false, 'msg'=>'ERROR: The vacancy verification instructions could not be resolved.');
        
        if (!empty($instructions['action'])) {
            switch ($instructions['action']) {
                case 'approve_toverify':
                    $result = $this->approval_chain->add_chain($instructions['id'], 'vacancy', '2', 'approved', (!empty($instructions['reason'])? htmlentities($instructions['reason'], ENT_QUOTES): 'NONE'));
                    $this->change_status($instructions['id'], 'verified');
                break;
                
                case 'reject_fromverify':
                    $result = $this->approval_chain->add_chain($instructions['id'], 'vacancy', '2', 'rejected', (!empty($instructions['reason'])? htmlentities($instructions['reason'], ENT_QUOTES): 'NONE'));
                break;
                
                case 'approve_topublish':
                    $result = $this->approval_chain->add_chain($instructions['id'], 'vacancy', '3', 'approved', (!empty($instructions['reason'])? htmlentities($instructions['reason'], ENT_QUOTES): 'NONE'));
                    # The vacancy status is changed by the approval chain
                break;
                
                case 'reject_frompublish':
                    $result = $this->approval_chain->add_chain($instructions['id'], 'vacancy', '3', 'rejected', (!empty($instructions['reason'])? htmlentities($instructions['reason'], ENT_QUOTES): 'NONE'));
                break;
                
                case 'archive':
                    $result = $this->change_status($instructions['id'], 'archived');
                break;
                
                case 'restore':
                    $result = $this->change_status($instructions['id'], 'saved');
                break;
            }
        }
        
        return $result;
    }
}
