<?php
/**
 * This helper manages form data on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/13/2015
 */
 
 
# Process data from the form
function process_fields($obj, $data, $required=array(), $allowChars=array())
{
    $session = session();
    $disallowChars = array("'", "\"", "\\", "(", ")", "/", "<", ">", "!", "#", "%", "&", "?", "$", ":", ";", "=", "*");
    if (!empty($allowChars)) {
        $disallowChars = array_diff($disallowChars, $allowChars);
    }
    # Did the data set pass the requried check
    $hasPassed = true;
    $finalData = array();
    $msg = "";
        
    foreach ($data as $key=>$value) {
        # Do not validate arrays
        if (!is_array($value)) {
            $value = htmlentities(trim($value), ENT_QUOTES);
            # Add if the string is not empty and does not contain any of the disallowed characters
            if (!empty($value) && !(0 < count(array_intersect(str_split(strtolower($value)), $disallowChars)))) {
            
                # If this is a birthday, check to see whether they are above 18 years of age
                if ($key == 'birthday') {
                    $userDate = new DateTime($value);
                    $today = new DateTime('now');
                    $difference = $userDate->diff($today);
                
                    if (!($difference->y >= 18)) {
                        $msg = "WARNING: The submitted birth date is not valid for a teacher.";
                        $hasPassed = false;
                    }
                }
                elseif ($key == 'nin') {
                    #Check for short NIN Numbers.
                    if (strlen($value) < 14) {
                        $msg = "WARNING: The submitted National Identification Number (NIN) is too short.";
                        $hasPassed = false;
                    }
                    elseif((substr(strtoupper($value),0,2) != "CM") && (substr(strtoupper($value),0,2) != "CF")){
                        $msg = "WARNING: The submitted National Identification Number (NIN) is invalid.";
                        $hasPassed = false;
                    }
                }
                elseif ($key == 'emis'){
                    #Validate EMIS numbers
                    $new ='/^[1-5][A-HJ-NP-Z][0-9]{6}$/';
                    $old = '/^[0-9]{2,6}$/';
                    if(!preg_match($new, $value) && !preg_match($old, $value)){
                        $msg = "WARNING: The submitted Education Management Information System (EMIS) Number is invalid.";
                        $hasPassed = false;
                    }

                }
                $session->set($key, $value);
                $finalData[$key] = $value;
            }
            # Catch the case where a required field was not entered
            elseif (in_array($key, $required)) {
                $hasPassed = false;
            }
        }
    }
        
    return array('boolean'=>$hasPassed, 'data'=>$finalData, 'msg'=>$msg);
}
 
 
 
 
# Copy the address provided in one field to another field
function copy_address($obj, $data)
{
    $session = session();
    $from = $data['from'];
    $to = $data['to'];
    
    if ($session->get($from.'__addresstype')) {
        $session->set($to.'__addresstype', $session->get($from.'__addresstype'));
    }
    if ($session->get($from.'__addressline')) {
        $session->set($to.'__addressline', $session->get($from.'__addressline'));
    }
    if ($session->get($from.'__county')) {
        $session->set($to.'__county', $session->get($from.'__county'));
    }
    if ($session->get($from.'__district')) {
        $session->set($to.'__district', $session->get($from.'__district'));
    }
    if ($session->get($from.'__country')) {
        $session->set($to.'__country', $session->get($from.'__country'));
    }
    
    # Simply return a confirmation that the address country is set
    return $session->get($from.'__country')? true: false;
}

 
 
 
 
# Remove address data from a field
function remove_address($obj, $data)
{
    $id = $data['field_id'];
    $session = session();
    $session->remove($id.'__addresstype');
    $session->remove($id.'__addressline');
    $session->remove($id.'__county');
    $session->remove($id.'__district');
    $session->remove($id.'__country');
    
    # Simply return a confirmation that the address country does not exist any more
    return $session->get($id.'__country')? false: true;
}
