<?php

namespace App\Controllers;

/**
 * This class controls viewing vacancy pages on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/20/2015
 */
use App\Models\_vacancy;

class Vacancy extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->vacancy = new _vacancy();
    }
    
    
    
    
    #Verify the vacancy before proceeding to the next stage
    public function verify()
    {
        $data = filter_forwarded_data($this);
        if (!empty($_POST)) {
            # Approve or reject a vacancy
            $result = $this->vacancy->verify($_POST);
            
            $actionPart = current(explode("_", $_POST['action']));
            $actions = array('approve'=>'approved', 'reject'=>'rejected', 'archive'=>'archived', 'restore'=>'restored', 'publish'=>'published');
            $actionWord = !empty($actions[$actionPart])? $actions[$actionPart]: 'made';
            $this->session->set('msg', ($result['boolean']? "The vacancy has been ".$actionWord: (!empty($result['msg'])? $result['msg']: "ERROR: The vacancy could not be ".$actionWord)));
        } else {
            # Get list type
            $data['list_type'] = current(explode("_", $data['action']));
            $data['area'] = 'verify_vacancy';
            echo view('addons/basic_addons', $data);
        }
    }
    
    # Add a new job
    public function add()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'add_new_job');
        # Remove any session variables if still in the session.
        $this->vacancy->clear_session();
        
        # If the user has posted the vacancy details
        if (!empty($_POST)) {
            # Editing vacancy
            if ($this->request->getPost('vacancyid')) {
                $data['result'] = $this->vacancy->updated($this->request->getPost('vacancyid'), $this->request->getPost());
            }
            # New vacancy
            else {
                $data['result'] = $this->vacancy->add_new($this->request->getPost());
            }
            
            $data['vacancy_id'] = !empty($data['result']['id'])? $data['result']['id']: '';
            $data['msg'] = $data['result']['boolean'] && empty($data['result']['msg'])? "Your job details have been saved.": $data['result']['msg'];
            # Redirect to appropriate page if successful
            $this->session->set('msg', $data['msg']);
            if ($data['result']['boolean'] && $this->request->getPost('forwardurl')) {
                return redirect()->to($this->request->getPost('forwardurl'));
            }
        }
        
        #If editing, load the id details into the session for the first time
        if (!empty($data['id']) && empty($_POST)) {
            $this->vacancy->populate_session($data['id']);
        }
        echo view('vacancy/new_vacancy', $data);
    }
    
    
    
    # View a job list
    public function lists()
    {
        $data = filter_forwarded_data($this);
        $instructions['action'] = array('publish'=>'publish_job_notices', 'verify'=>'verify_job_notices', 'archive'=>'archive_job_notices', 'report'=>'view_jobs');
        check_access($this, get_access_code($data, $instructions));
        
        $data['list'] = $this->vacancy->get_list($data);
        echo view('vacancy/list_vacancies', $data);
    }
    
    
    
    # View a job's details
    public function details()
    {
        $data = filter_forwarded_data($this);
        
        if (!empty($data['id'])) {
            $data['details'] = $this->vacancy->get_details($data['id']);
        } else {
            $data['msg'] = "ERROR: We could not find the vacancy details.";
        }
        
        echo view('vacancy/details', $data);
    }
    
    
    
    
    # Download the list
    public function download()
    {
        check_access($this, 'view_jobs');
        
        $data['list'] = array();
        $list = $this->vacancy->get_list(array('action'=>'download', 'pagecount'=>DOWNLOAD_LIMIT));
        foreach ($list as $row) {
            array_push($data['list'], array('School'=>$row['institution_name'], 'Role'=>$row['role_name'], 'Job Title'=>$row['topic'], 'Publish Start'=>date('d-M-Y', strtotime($row['start_date'])), 'Publish End'=>date('d-M-Y', strtotime($row['end_date'])), 'Summary'=>$row['summary'] ));
        }
        
        $data['area'] = 'download_csv';
        echo view('page/download', $data);
    }
}

/* End of controller file */
