<?php

namespace App\Controllers;

/**
 * This class controls viewing retirement pages on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/20/2015
 */
use App\Models\_retirement;
use App\Models\_job;

class Retirement extends BaseController
{
    # Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->retirement = new _retirement();
        $this->job = new _job();
    }
    
    
    # View retirement application list
    public function lists()
    {
        $data = filter_forwarded_data($this);
        if (empty($data['action'])) {
            $data['action'] = 'view';
        }
        $instructions['action'] = array('view'=>'view_retirement_applications', 'approve'=>'verify_retirement_application', 'report'=>'view_retirements');
        check_access($this, get_access_code($data, $instructions));
        
        $data['list'] = $this->retirement->get_list($data);
        #Make sure the approver has a signature on file if they are going to issue a letter
        if (!empty($data['list']) && !$this->session->get('__signature') && !empty($data['action']) && $data['action'] == 'approve') {
            $data['msg'] = "WARNING: You need to <a href='".base_url()."/Profile/user_data'>upload a signature</a> to generate a retirement document.";
            $this->session->set('__nosignature', 'Y');
        }
        echo view('retirement/list_retirements', $data);
    }
    
    
    
    # Cancel a retirement application
    public function cancel()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'cancel_retirement_application');
        
        if (!empty($data['submit'])) {
            $result = $this->retirement->cancel();
            $data['msg'] = $result? 'The retirement application has been cancelled.': 'ERROR: The retirement application could not be cancelled.';
            $data['area'] = 'basic_msg';
            echo view('addons/basic_addons', $data);
        } else {
            $data['application'] = $this->retirement->get_application();
        
            $data['area'] = 'cancel_retirement_application';
            $data['job'] = $this->job->populate_session();
            echo view('job/my_profile', $data);
        }
    }
    
    
    # Verify a retirement application
    public function verify()
    {
        $data = filter_forwarded_data($this);
        if (!empty($_POST)) {
            # Approve or reject a retirement
            $result = $this->retirement->verify($_POST);
            
            $actionPart = current(explode("_", $_POST['action']));
            $actions = array('reject'=>'rejected', 'approve'=>'approved');
            $actionWord = !empty($actions[$actionPart])? $actions[$actionPart]: 'made';
            
            $this->session->set('msg', ($result['boolean']? "The retirement has been ".$actionWord: (!empty($result['msg'])? $result['msg']: "ERROR: The retirement could not be ".$actionWord)));
        } else {
            # Get list type
            $data['list_type'] = current(explode("_", $data['action']));
            $data['area'] = 'verify_retirement';
            echo view('retirement/addons', $data);
        }
    }
    
    
    
    # Apply for retirement
    public function apply()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'apply_to_retire');
        
        if (!empty($_POST)) {
            $result = $this->retirement->submit_application($this->request->getPost());
            $data['msg'] = $result['boolean']? 'Your retirement application has been submitted.': $result['msg'];
            
            if ($result['boolean']) {
                $this->session->set('msg', $data['msg']);
                return redirect()->to('retirement/cancel');
            }
        }
        
        $data['current_application'] = $this->retirement->details($this->session->get('__user_id'));
        echo view('retirement/apply', $data);
    }
    
    
    
    
    # Download the list
    public function download()
    {
        check_access($this, 'view_retirements');
        
        $data['list'] = array();
        $list = $this->retirement->get_list(array('action'=>'download', 'pagecount'=>DOWNLOAD_LIMIT));
        foreach ($list as $row) {
            array_push($data['list'], array('File Number'=>$row['file_number'], 'Teacher Name'=>$row['teacher_name'], 'Job Title'=>$row['job'], 'Planned Date'=>date('d-M-Y', strtotime($row['proposed_date'])).($row['confirmed_date'] != '0000-00-00'? ' (ACTUAL: '.date('d-M-Y', strtotime($row['confirmed_date'])).')': ''), 'Age'=>$row['age'], 'Reason'=>$row['retiree_reason'] ));
        }
        
        $data['area'] = 'download_csv';
        echo view('page/download', $data);
    }
}

/* End of controller file */
