<?php

namespace App\Controllers;

use App\Models\_permission;

/**
 * This class controls viewing permission pages on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/20/2015
 */

class Permission extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->permission =new _permission();
    }
    
    
    
    
    # View list of permissions
    public function lists()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'view_permission_list');
        
        $data['list'] = $this->permission->get_list();
        echo view('permission/list_permissions', $data);
    }
    
    
    # View list of permission groups
    public function group_list()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'view_permission_group_list');
        
        $data['list'] = $this->permission->get_list(array('action'=>'grouplist'));
        $data['action'] = 'grouplist';
        echo view('permission/list_permissions', $data);
    }
    
    
    
    # View list of users and their permissions
    public function user_list()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'view_user_permissions');
        
        $data['list'] = $this->permission->get_list(array('action'=>'userlist'));
        $data['action'] = 'userlist';
        echo view('permission/list_permissions', $data);
    }
    
    
    # View group permissions
    public function group_permissions()
    {
        $data = filter_forwarded_data($this);
        
        $data['list'] = $this->permission->get_list(array('action'=>'grouppermissionlist', 'group_id'=>$data['id']));
        $data['area'] = 'permission_list';
        echo view('addons/basic_addons', $data);
    }
    
    
    # Add a permission group
    public function add_group()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'add_new_permission_group');
        $fields = ['groupname', 'permissions', 'permission', 'default', 'forsystem', 'telephone'];
        $this->session->remove($fields);
        
        #User has posted the form
        if (!empty($_POST)) {
            $data['result'] = $this->request->getPost('groupid')? $this->permission->update_group_permissions($this->request->getPost('groupid'), $this->request->getPost()): $this->permission->add_new_group($this->request->getPost());
            
            $data['msg'] = $data['result']['boolean'] && empty($data['result']['msg'])? "The group details have been saved.": $data['result']['msg'];
            
            # Redirect to appropriate page if successful
            if ($data['result']['boolean']) {
                $this->session->remove($fields);
                $this->session->set('msg', $data['msg']);
                if ($this->request->getPost('groupid')) {
                    $data['forward'] = base_url().$this->request->getPost('forward');
                }
                if (!$this->request->getPost('groupid') && $this->request->getPost('forward')) {
                    return redirect()->to($this->request->getPost('forward'));
                }
            }
        }
        
        #Put the data in the session that is going to be edited
        if (!empty($data['id']) && empty($_POST)) {
            $this->permission->populate_session($data['id']);
        }
        
        # High page count is to help return all of the permissions
        $data['permission_list'] = $this->permission->get_list(array('pagecount'=>1000));
        echo view('permission/new_group', $data);
    }
    
    
    #Update a group's permissions
    public function update_group()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'change_group_permissions');
        
        $data['list'] = $this->permission->get_list(array('action'=>'updategroups'));
        $data['action'] = 'updategroups';
        echo view('permission/list_permissions', $data);
    }
    
    
    
    # Verify the permission group
    public function verify()
    {
        $data = filter_forwarded_data($this);
        if (!empty($_POST)) {
            # Approve or reject a permission group
            $result = $this->permission->verify($_POST);
            $this->session->set('msg', ($result['boolean']? "The permission group has been rejected.": (!empty($result['msg'])? $result['msg']: "ERROR: The user could not be rejected.")));
        } else {
            # Get list type
            $data['list_type'] = current(explode("_", $data['action']));
            $data['area'] = 'verify_permission';
            echo view('addons/basic_addons', $data);
        }
    }
}

/* End of controller file */
