<?php

/*
 | --------------------------------------------------------------------
 | App Namespace
 | --------------------------------------------------------------------
 |
 | This defines the default Namespace that is used throughout
 | CodeIgniter to refer to the Application directory. Change
 | this constant to change the namespace that all application
 | classes should use.
 |
 | NOTE: changing this will require manually modifying the
 | existing namespaces of App\* namespaced-classes.
 */
defined('APP_NAMESPACE') || define('APP_NAMESPACE', 'App');

/*
 | --------------------------------------------------------------------------
 | Composer Path
 | --------------------------------------------------------------------------
 |
 | The path that Composer's autoload file is expected to live. By default,
 | the vendor folder is in the Root directory, but you can customize that here.
 */
defined('COMPOSER_PATH') || define('COMPOSER_PATH', ROOTPATH . 'vendor/autoload.php');

/*
 |--------------------------------------------------------------------------
 | Timing Constants
 |--------------------------------------------------------------------------
 |
 | Provide simple ways to work with the myriad of PHP functions that
 | require information to be in seconds.
 */
defined('SECOND') || define('SECOND', 1);
defined('MINUTE') || define('MINUTE', 60);
defined('HOUR')   || define('HOUR', 3600);
defined('DAY')    || define('DAY', 86400);
defined('WEEK')   || define('WEEK', 604800);
defined('MONTH')  || define('MONTH', 2592000);
defined('YEAR')   || define('YEAR', 31536000);
defined('DECADE') || define('DECADE', 315360000);

/*
 | --------------------------------------------------------------------------
 | Exit Status Codes
 | --------------------------------------------------------------------------
 |
 | Used to indicate the conditions under which the script is exit()ing.
 | While there is no universal standard for error codes, there are some
 | broad conventions.  Three such conventions are mentioned below, for
 | those who wish to make use of them.  The CodeIgniter defaults were
 | chosen for the least overlap with these conventions, while still
 | leaving room for others to be defined in future versions and user
 | applications.
 |
 | The three main conventions used for determining exit status codes
 | are as follows:
 |
 |    Standard C/C++ Library (stdlibc):
 |       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
 |       (This link also contains other GNU-specific conventions)
 |    BSD sysexits.h:
 |       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
 |    Bash scripting:
 |       http://tldp.org/LDP/abs/html/exitcodes.html
 |
 */
defined('EXIT_SUCCESS')        || define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          || define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         || define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   || define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  || define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') || define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     || define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       || define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      || define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      || define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code

/*
 *---------------------------------------------------------------
 * QUERY CACHE SETTINGS
 *---------------------------------------------------------------
 */
    
defined('ENABLE_QUERY_CACHE') || define('ENABLE_QUERY_CACHE', false);
defined('QUERY_FILE') || define('QUERY_FILE', ROOTPATH . 'app/Helpers/queries_list_helper.php');

/*
 *---------------------------------------------------------------
 * MESSAGE CACHE SETTINGS
 *---------------------------------------------------------------
 */
    
defined('ENABLE_MESSAGE_CACHE') || define('ENABLE_MESSAGE_CACHE', false);
    
defined('MESSAGE_FILE') || define('MESSAGE_FILE', ROOTPATH . 'app/Helpers/message_list_helper.php');

/*
 *---------------------------------------------------------------
 * SMS GLOBAL CREDENTIALS
 *---------------------------------------------------------------
 */
    
defined('SMS_GLOBAL_USERNAME') || define('SMS_GLOBAL_USERNAME', '6yb6snqt');
    
defined('SMS_GLOBAL_PASSWORD') || define('SMS_GLOBAL_PASSWORD', 'q9gP5552');

defined('SMS_GLOBAL_VERIFIED_SENDER') || define('SMS_GLOBAL_VERIFIED_SENDER', '16786442425');

/*
 *---------------------------------------------------------------
 * COMMUNICATION SETTINGS
 *---------------------------------------------------------------
 */
    
defined('NOREPLY_EMAIL') || define("NOREPLY_EMAIL", "noreply@nwt.ug");

defined('HELP_EMAIL') || define("HELP_EMAIL", "support@tmis.go.ug");
                    
defined('SITE_ADMIN_MAIL') || define('SITE_ADMIN_MAIL', "admin@tmis.go.ug");

defined('SIGNUP_EMAIL') || define("SIGNUP_EMAIL", "register@tmis.go.ug");

defined('SITE_ADMIN_NAME') || define('SITE_ADMIN_NAME', "TMIS Admin");

defined('SITE_GENERAL_NAME') || define('SITE_GENERAL_NAME', "TMIS");

defined('DEV_TEST_EMAIL') || define('DEV_TEST_EMAIL', "dev@tmis.go.ug");

/*
 *---------------------------------------------------------------
 * EMAIL SETTINGS
 *---------------------------------------------------------------
 */
defined('SMTP_HOST') || define('SMTP_HOST', "mail.supremecluster.com");
    
defined('SMTP_PORT') || define('SMTP_PORT', "465");

defined('SMTP_USER') || define('SMTP_USER', "noreply@nwt.ug");

defined('SMTP_PASS') || define('SMTP_PASS', "8GD17Cduo=");

defined('FLAG_TO_REDIRECT') || define('FLAG_TO_REDIRECT', "0"); # 1 => Redirect emails to a specific mail id,
                                                                # 0 => No need to redirect emails.

/*
* If "FLAG_TO_REDIRECT" is set to 1, it will redirect all the mails from this site
* to the email address  defined in "MAILID_TO_REDIRECT".
*/
    
defined('MAILID_TO_REDIRECT') || define('MAILID_TO_REDIRECT', DEV_TEST_EMAIL);

/*
 *---------------------------------------------------------------
 * GLOBAL SETTINGS
 *---------------------------------------------------------------
 */
defined('RETRIEVE_URL_DATA_IGNORE') || define('RETRIEVE_URL_DATA_IGNORE', 3); # The starting point to obtain the passed url data

defined('SITE_TITLE') || define('SITE_TITLE', "TMIS");

defined('SITE_SLOGAN') || define('SITE_SLOGAN', "");

defined('NUM_OF_ROWS_PER_PAGE') || define('NUM_OF_ROWS_PER_PAGE', "5");

defined('NUM_OF_LISTS_PER_VIEW') || define('NUM_OF_LISTS_PER_VIEW', "10");

defined('UPLOAD_DIRECTORY') || define('UPLOAD_DIRECTORY', ROOTPATH . "public/assets/uploads/");

defined('DOWNLOAD_LIMIT') || define('DOWNLOAD_LIMIT', 10000); # Max number of rows that can be downloaded

defined('RETIREMENT_AGE') || define('RETIREMENT_AGE', 60); # Mandatory retirement age

defined('MINIFY') || define('MINIFY', false);
